#include "csfunified/library/CSFUnified.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/featuresets/adapters/MeetingFeatureSetAdapter.h"
#include "services/interface/MeetingServiceFeatureSetTypes.h"
#include "services/interface/MeetingAuthenticatorIds.h"
#include "services/interface/MeetingServiceIds.h"
#include "services/impl/MeetingServiceImpl.h"
#include "autoupgrade/MeetingSDKMgr.h"

#ifdef WIN32
#include "sdkwrapper/win32/autoupgrade/jabber_sdk_wrap_impl.h"
using namespace JM_SDK_WRAP;
#else
#include "sdkwrapper/mac/MeetingSDKWrap.h"
#endif

#ifdef JCF_REFLECTION
#include "csfunified/services/reflectors/MeetingServiceModuleReflector.h"
#endif

namespace CSFUnified
{	
	// injection method for dynamic linking from framework, called after dll is loaded

	extern "C" CSFUNIFIED_API void InjectMeetingService(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
	{
        if (NULL == unifiedFactory.get())
        {
            return;
        }
        
        MeetingSDKMgr::getInstance()->setUnifiedFactory(unifiedFactory);
#ifdef WIN32
		if(!JabberSDKWrapImpl::getInstance()->IsSDKLoadSuccessful())
#else
        if(!MeetingSDKWrap::getInstance()->IsSDKLoadSuccessfull())
#endif
        {
            return;
        }

		SMART_PTR_NS::shared_ptr<MeetingService> meetingService(new MeetingServiceImpl(unifiedFactory));		
        unifiedFactory->setService<MeetingService>(MeetingServiceIdsEnum::MeetingService, meetingService);

        SMART_PTR_NS::shared_ptr<MeetingFeatureSetAdapter> meetingAdapter(new MeetingFeatureSetAdapter(unifiedFactory));
        unifiedFactory->setFeatureSetAdapter<MeetingFeatureSet>(MeetingServiceFeatureSetTypesEnum::Meeting, meetingAdapter);
        
#ifdef JCF_REFLECTION
        MeetingServiceModuleReflectorInjector::InjectReflectors();
#endif
	}
}